/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public class PhilipsAirConfiguration {
    public static final String CONFIG_KEY = "key";
    public static final String CONFIG_DEF_DEVICE_UUID = "deviceUUID";
    public static final String CONFIG_DEF_REFRESH_INTERVAL = "refreshInterval";
    public static final String CONFIG_DEF_MODEL_ID = "modelid";
    public static final String CONFIG_DEF_HUMIDITY_OFFSET = "humidityOffset";
    public static final String CONFIG_DEF_TEMPERATURE_OFFSET = "temperatureOffset";
    public static final String CONFIG_HOST = "host";
    public static final int MIN_REFESH_INTERVAL = 5;
    private int refreshInterval = 60;
    private String host = "";
    private String deviceUUID = "";
    private String key = "";
    private String modelid = "";
    private float temperatureOffset;
    private float humidityOffset;

    public void updateFromProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            if (e.getKey() == null) continue;
            switch (e.getKey()) {
                case "key": {
                    this.setKey((String)e.getValue());
                    break;
                }
                case "host": {
                    this.setHost((String)e.getValue());
                    break;
                }
                case "refreshInterval": {
                    this.setRefreshInterval((Integer)e.getValue());
                    break;
                }
                case "deviceUUID": {
                    this.setDeviceUUID((String)e.getValue());
                    break;
                }
                case "modelid": {
                    this.setModelid((String)e.getValue());
                    break;
                }
                case "humidityOffset": {
                    this.setHumidityOffset(((Float)e.getValue()).floatValue());
                    break;
                }
                case "temperatureOffset": {
                    this.setTemperatureOffset(((Float)e.getValue()).floatValue());
                }
            }
        }
    }

    public void updateFromProperties(Dictionary<String, Object> properties) {
        ArrayList<String> keys = Collections.list(properties.keys());
        Map<String, Object> dictCopy = keys.stream().collect(Collectors.toMap(Function.identity(), properties::get));
        this.updateFromProperties(dictCopy);
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public String getModelid() {
        return this.modelid;
    }

    public void setModelid(String modelid) {
        this.modelid = modelid;
    }

    public double getTemperatureOffset() {
        return this.temperatureOffset;
    }

    public void setTemperatureOffset(float temperatureOffset) {
        this.temperatureOffset = temperatureOffset;
    }

    public float getHumidityOffset() {
        return this.humidityOffset;
    }

    public void setHumidityOffset(float humidityOffset) {
        this.humidityOffset = humidityOffset;
    }
}

