/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.openhab.binding.philipsair.internal.PhilipsAirBindingConstants;
import org.openhab.binding.philipsair.internal.PhilipsAirConfiguration;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirAPIConnection;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirAPIException;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirCoapAPIConnection;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirHttpAPIConnection;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDataDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDeviceDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierFiltersDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierWritableDataDTO;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.types.StringType;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingStatus;
import org.openhab.core.thing.ThingStatusDetail;
import org.openhab.core.thing.binding.BaseThingHandler;
import org.openhab.core.thing.binding.ThingHandlerCallback;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PhilipsAirHandler
extends BaseThingHandler {
    private static final long INITIAL_DELAY_IN_SECONDS = 10L;
    private final Logger logger = LoggerFactory.getLogger(PhilipsAirHandler.class);
    private @Nullable ScheduledFuture<?> refreshJob;
    private @Nullable PhilipsAirAPIConnection connection;
    private @Nullable PhilipsAirPurifierDataDTO currentData;
    private @Nullable PhilipsAirPurifierDeviceDTO deviceInfo;
    private @Nullable PhilipsAirPurifierFiltersDTO filters;
    private final HttpClient httpClient;

    public PhilipsAirHandler(Thing thing, HttpClient httpClient) {
        super(thing);
        this.httpClient = httpClient;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (this.connection == null) {
            return;
        }
        if (command == RefreshType.REFRESH) {
            this.logger.debug("Refreshing {}", (Object)channelUID);
            this.updateData(this.connection);
        } else {
            this.logger.debug("Sending {} as {}", (Object)channelUID.getId(), (Object)command.toString());
            PhilipsAirPurifierWritableDataDTO commandData = this.prepareCommandData(channelUID.getIdWithoutGroup(), command);
            try {
                this.currentData = this.connection.sendCommand(channelUID.getIdWithoutGroup(), commandData);
            }
            catch (PhilipsAirAPIException e) {
                this.logger.debug("An exception occured", (Throwable)e);
            }
            this.updateChannels();
        }
    }

    public PhilipsAirPurifierWritableDataDTO prepareCommandData(String parameter, Command command) {
        OnOffType onOffCommand = null;
        DecimalType decimalCommand = null;
        String stringCommand = null;
        if (command instanceof OnOffType) {
            onOffCommand = (OnOffType)command;
        } else if (command instanceof DecimalType) {
            decimalCommand = (DecimalType)command;
        } else if (command instanceof StringType) {
            stringCommand = command.toString();
        }
        PhilipsAirPurifierWritableDataDTO data = new PhilipsAirPurifierWritableDataDTO();
        switch (parameter) {
            case "aqil": {
                if (decimalCommand == null) break;
                data.setLightLevel(decimalCommand.intValue());
                break;
            }
            case "ddp": {
                if (stringCommand == null) break;
                data.setDisplayIndex(stringCommand);
                break;
            }
            case "uil": {
                if (onOffCommand == null || onOffCommand.as(DecimalType.class) == null) break;
                data.setButtons(((DecimalType)onOffCommand.as(DecimalType.class)).toString());
                break;
            }
            case "pwr": {
                if (onOffCommand == null || onOffCommand.as(DecimalType.class) == null) break;
                data.setPower(((DecimalType)onOffCommand.as(DecimalType.class)).toString());
                break;
            }
            case "om": {
                if (stringCommand != null) {
                    data.setFanSpeed(stringCommand);
                }
                data.setMode("M");
                break;
            }
            case "cl": {
                if (onOffCommand == null || onOffCommand.as(DecimalType.class) == null) break;
                data.setChildLock(command == OnOffType.ON);
                break;
            }
            case "dt": {
                if (decimalCommand == null) break;
                data.setTimer(decimalCommand.intValue());
                break;
            }
            case "mode": {
                if (stringCommand == null) break;
                data.setMode(stringCommand);
                break;
            }
            case "aqit": {
                if (decimalCommand == null) break;
                data.setAqit(decimalCommand.intValue());
                break;
            }
            case "rhset": {
                if (decimalCommand == null) break;
                data.setHumiditySetpoint(decimalCommand.intValue());
                break;
            }
            case "func": {
                if (stringCommand == null) break;
                data.setFunction(stringCommand);
            }
        }
        return data;
    }

    public void initialize() {
        ThingHandlerCallback callback;
        this.logger.debug("Start initializing!");
        PhilipsAirConfiguration config = this.getAirPurifierConfig();
        int refreshInterval = config.getRefreshInterval();
        if (refreshInterval < 5 && !PhilipsAirBindingConstants.SUPPORTED_COAP_THING_TYPES_UIDS.contains(this.getThing().getThingTypeUID())) {
            this.logger.info("refreshInterval too low. Using {}", (Object)5);
            refreshInterval = 5;
        }
        if ((callback = this.getCallback()) != null) {
            callback.configurationUpdated(this.thing);
        }
        this.updateStatus(ThingStatus.OFFLINE);
        this.scheduler.submit(() -> this.getConnection(config));
        ScheduledFuture<?> refreshJob = this.refreshJob;
        if (refreshJob == null || refreshJob.isCancelled()) {
            this.logger.debug("Start refresh job at interval {} sec.", (Object)refreshInterval);
            this.refreshJob = this.scheduler.scheduleWithFixedDelay(this::updateThing, 10L, refreshInterval, TimeUnit.SECONDS);
        }
    }

    private void getConnection(PhilipsAirConfiguration config) {
        if (PhilipsAirBindingConstants.SUPPORTED_COAP_THING_TYPES_UIDS.contains(this.getThing().getThingTypeUID())) {
            this.logger.debug("Starting Coap based connectivity");
            this.connection = new PhilipsAirCoapAPIConnection(config);
        } else {
            this.logger.debug("Starting HTTP based connectivity");
            this.connection = new PhilipsAirHttpAPIConnection(config, this.httpClient);
        }
    }

    public void dispose() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel(true);
        }
        super.dispose();
    }

    private void updateThing() {
        try {
            if (this.connection != null) {
                this.updateData(this.connection);
            } else {
                this.logger.debug("Cannot update Air Purifier device {}", (Object)this.thing.getUID());
                this.getConnection(this.getAirPurifierConfig());
            }
        }
        catch (Exception e) {
            this.logger.info("Exception while updating thing: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void updateData(@Nullable PhilipsAirAPIConnection connection) {
        try {
            if (this.requestData(connection)) {
                this.updateChannels();
                this.updateStatus(ThingStatus.ONLINE);
            }
        }
        catch (PhilipsAirAPIException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getLocalizedMessage());
        }
    }

    protected boolean requestData(@Nullable PhilipsAirAPIConnection connection) throws PhilipsAirAPIException {
        if (connection == null) {
            return false;
        }
        String host = this.getAirPurifierConfig().getHost();
        PhilipsAirPurifierDeviceDTO deviceInfo = connection.getAirPurifierDevice(host);
        PhilipsAirPurifierDataDTO data = connection.getAirPurifierStatus(host);
        PhilipsAirPurifierFiltersDTO filters = null;
        List filterGroup = this.thing.getChannelsOfGroup("filters");
        if (filterGroup.stream().anyMatch(fg -> this.isLinked(fg.getUID()))) {
            filters = connection.getAirPurifierFiltersStatus(host);
        }
        if (data != null) {
            this.currentData = data;
        }
        if (deviceInfo != null) {
            this.deviceInfo = deviceInfo;
            this.getAirPurifierConfig().setModelid(deviceInfo.getModelId());
            this.getConfig().put("modelid", (Object)deviceInfo.getModelId());
            this.getConfig().put("key", (Object)connection.getConfig().getKey());
            Map<String, String> properties = PhilipsAirHandler.fillDeviceProperties(deviceInfo, this.editProperties());
            this.updateProperties(properties);
            ThingHandlerCallback callback = this.getCallback();
            if (callback != null) {
                callback.configurationUpdated(this.thing);
            }
        }
        if (filters != null) {
            this.filters = filters;
        }
        return data != null || deviceInfo != null || filters != null;
    }

    private void updateChannels() {
        if (this.getCallback() != null) {
            for (Channel channel : this.getThing().getChannels()) {
                ChannelUID channelUID = channel.getUID();
                if (!ChannelKind.STATE.equals((Object)channel.getKind()) || !this.isLinked(channelUID)) continue;
                this.updateChannel(channelUID, this.currentData, this.deviceInfo, this.filters);
            }
        }
    }

    protected void updateChannel(ChannelUID channelUID, @Nullable PhilipsAirPurifierDataDTO data, @Nullable PhilipsAirPurifierDeviceDTO deviceInfo, @Nullable PhilipsAirPurifierFiltersDTO filters) {
        if (this.getCallback() != null && this.isLinked(channelUID)) {
            Object value;
            try {
                value = this.getValue(channelUID, data, deviceInfo, filters);
            }
            catch (Exception e) {
                this.logger.debug("AirPurifier doesn't provide '{}' measurement. To avoid this message unlink  channel: {}", (Object)channelUID.getId(), (Object)channelUID.getAsString());
                return;
            }
            UnDefType state = UnDefType.NULL;
            if (value instanceof OnOffType) {
                state = (OnOffType)value;
            } else if (value instanceof QuantityType) {
                state = (QuantityType)value;
            } else if (value instanceof Integer) {
                state = new DecimalType((Number)BigDecimal.valueOf(((Integer)value).longValue()));
            } else if (value instanceof String) {
                state = new StringType(value.toString());
            } else if (value != null) {
                this.logger.warn("Update channel {}: Unsupported value type {}", (Object)channelUID, (Object)value.getClass().getSimpleName());
            }
            this.updateState(channelUID, (State)state);
        }
    }

    protected void updateState(ChannelUID channelUID, State state) {
        super.updateState(channelUID, state);
    }

    public @Nullable Object getValue(ChannelUID channelUID, @Nullable PhilipsAirPurifierDataDTO data, @Nullable PhilipsAirPurifierDeviceDTO deviceInfo, @Nullable PhilipsAirPurifierFiltersDTO filters) {
        block81: {
            String field;
            block83: {
                field = channelUID.getIdWithoutGroup();
                if (data == null) break block81;
                switch (field) {
                    case "aqil": {
                        return data.getLightLevel();
                    }
                    case "ddp": {
                        return data.getDisplayIndex();
                    }
                    case "uil": {
                        return data.getButtons().equals("0") ? OnOffType.OFF : OnOffType.ON;
                    }
                    case "pwr": {
                        return data.getPower().equals("0") ? OnOffType.OFF : OnOffType.ON;
                    }
                    case "pm25": {
                        return new QuantityType((Number)data.getPm25(), PhilipsAirBindingConstants.DENSITY_UNIT);
                    }
                    case "om": {
                        return data.getFanSpeed();
                    }
                    case "cl": {
                        return data.getChildLock() ? OnOffType.ON : OnOffType.OFF;
                    }
                    case "dt": {
                        return data.getTimer();
                    }
                    case "dtrs": {
                        return data.getTimerLeft();
                    }
                    case "mode": {
                        return data.getMode();
                    }
                    case "iaql": {
                        return data.getAllergenLevel();
                    }
                    case "aqit": {
                        return data.getAqit();
                    }
                    case "err": {
                        return String.valueOf(data.getErrorCode());
                    }
                    case "rh": {
                        return new QuantityType((Number)Float.valueOf(data.getHumidity() + this.getAirPurifierConfig().getHumidityOffset()), PhilipsAirBindingConstants.HUMIDITY_UNIT);
                    }
                    case "rhset": {
                        return data.getHumiditySetpoint();
                    }
                    case "temp": {
                        return new QuantityType((Number)((double)data.getTemperature() + this.getAirPurifierConfig().getTemperatureOffset()), PhilipsAirBindingConstants.TEMPERATURE_UNIT);
                    }
                    case "func": {
                        return data.getFunction();
                    }
                    case "wl": {
                        return data.getWaterLevel();
                    }
                }
                if (deviceInfo == null) break block83;
                switch (field) {
                    case "swversion": {
                        return deviceInfo.getSoftwareVersion();
                    }
                }
            }
            if (filters == null) break block81;
            switch (field) {
                case "fltsts0": {
                    return filters.getPreFilter();
                }
                case "wicksts": {
                    return filters.getWickFilter();
                }
                case "fltsts2": {
                    return filters.getCarbonFilter();
                }
                case "fltsts1": {
                    return filters.getHepaFilter();
                }
            }
        }
        return null;
    }

    public PhilipsAirConfiguration getAirPurifierConfig() {
        return (PhilipsAirConfiguration)this.getConfigAs(PhilipsAirConfiguration.class);
    }

    private static Map<String, String> fillDeviceProperties(PhilipsAirPurifierDeviceDTO device, Map<String, String> properties) {
        properties.put("vendor", "Philips");
        if (device != null) {
            properties.put("modelId", device.getModelId());
            properties.put("firmwareVersion", device.getSoftwareVersion());
            properties.put("name", device.getName());
        }
        return properties;
    }
}

