/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.binding.philipsair.internal.PhilipsAirBindingConstants;
import org.openhab.binding.philipsair.internal.PhilipsAirHandler;
import org.openhab.core.io.net.http.HttpClientFactory;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.binding.BaseThingHandlerFactory;
import org.openhab.core.thing.binding.ThingHandler;
import org.openhab.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(configurationPid={"binding.philipsair"}, service={ThingHandlerFactory.class})
public class PhilipsAirHandlerFactory
extends BaseThingHandlerFactory {
    @NonNullByDefault(value={})
    private HttpClientFactory httpClientFactory;

    public HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return PhilipsAirBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        if (PhilipsAirBindingConstants.SUPPORTED_THING_TYPES_UIDS.contains(thing.getThingTypeUID())) {
            return new PhilipsAirHandler(thing, this.httpClientFactory.getCommonHttpClient());
        }
        return null;
    }

    @Reference
    void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    protected void unsetHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = null;
    }
}

