/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal.connection;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PhilipsAirCipher {
    private static final String AA = "AA";
    private final Logger logger = LoggerFactory.getLogger(PhilipsAirCipher.class);
    private static final BigInteger G = new BigInteger(Base64.getDecoder().decode("AKTRy9XD/TQSZ2WkQu+5mQX4EE3SWKxQf9ZAbP8UJm0xJm/qHlxBVkt3fmkPVQTyExYCF7SwG4hqXpFUf54nSfTX+9fTuaku4ZCdDSJj+Ap2pqJMCHoJH1MdvwoBabaiitZipNGOc6+jLXedWRjQi8iFj03O+XwqJIVebusis7Ll"));
    private static final BigInteger P = new BigInteger(Base64.getDecoder().decode("ALELj5aggOAd3pLeXq5dVOxSyZ+8+wajxppqncpS0jthYHPihnWiPRiYOO8eLuZSwBPstK6pBhEjJJdcPNSbg7+sy919kMS9cJhIjpwhmnNyTv/W+uVkRzj6oxpP9VvMwKFRr18NyLS9Rb833zZcGmXmjP2nbU2nCN8fsrwuSkNx"));
    private static final Random RAND = new Random();
    private @Nullable Cipher decipher;
    private @Nullable Cipher cipher;
    private final BigInteger a;
    private final BigInteger aPow;

    public PhilipsAirCipher() throws GeneralSecurityException {
        this(PhilipsAirCipher.randomForBitsNonZero(256));
    }

    public PhilipsAirCipher(BigInteger randomSeed) throws GeneralSecurityException {
        this.a = randomSeed;
        this.aPow = G.modPow(this.a, P);
    }

    public void initKey(String key) throws GeneralSecurityException {
        try {
            this.decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.decipher.init(2, (Key)new SecretKeySpec(HexUtils.hexToBytes((String)key), "AES"), new IvParameterSpec(new byte[16]));
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.cipher.init(1, (Key)new SecretKeySpec(HexUtils.hexToBytes((String)key), "AES"), new IvParameterSpec(new byte[16]));
        }
        catch (GeneralSecurityException e) {
            this.logger.warn("An exception occured", (Throwable)e);
            this.cipher = null;
            this.decipher = null;
            throw e;
        }
    }

    public String getApow() {
        return this.aPow.toString(16);
    }

    private static BigInteger randomForBitsNonZero(int numBits) {
        BigInteger candidate = new BigInteger(numBits, RAND);
        while (candidate.equals(BigInteger.ZERO)) {
            candidate = new BigInteger(numBits, RAND);
        }
        return candidate;
    }

    public String calculateKey(String hellman, String key) throws GeneralSecurityException, InterruptedException, TimeoutException, ExecutionException, InvalidAlgorithmParameterException {
        BigInteger b = new BigInteger(hellman, 16);
        BigInteger s = b.modPow(this.a, P);
        byte[] sByteArray = s.toByteArray();
        if (sByteArray.length > 128 && sByteArray[0] == 0) {
            sByteArray = Arrays.copyOfRange(sByteArray, 1, 128);
        }
        byte[] sByteArrayTrunc = Arrays.copyOfRange(sByteArray, 0, 16);
        byte[] hexKey = HexUtils.hexToBytes((String)key);
        Cipher ciph = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ciph.init(2, (Key)new SecretKeySpec(sByteArrayTrunc, "AES"), new IvParameterSpec(new byte[16]));
        byte[] keyDecoded = ciph.doFinal(hexKey);
        String aesKey = HexUtils.bytesToHex((byte[])keyDecoded).substring(0, 32);
        return aesKey;
    }

    public @Nullable String decrypt(String encodedContent) throws IllegalBlockSizeException, BadPaddingException {
        if (this.decipher == null) {
            return null;
        }
        byte[] decoded = this.decipher.doFinal(Base64.getDecoder().decode(encodedContent));
        byte[] unpaded = Arrays.copyOfRange(decoded, 2, decoded.length);
        return new String(unpaded, StandardCharsets.US_ASCII);
    }

    public @Nullable String encrypt(String data) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher == null) {
            return null;
        }
        String encodedData = AA + data;
        byte[] encryptedBytes = this.cipher.doFinal(encodedData.getBytes(StandardCharsets.US_ASCII));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }
}

