/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal.connection;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.exception.ConnectorException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.binding.philipsair.internal.PhilipsAirConfiguration;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirAPIConnection;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirAPIException;
import org.openhab.binding.philipsair.internal.connection.PhilipsAirCoapCipher;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDataDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDeviceDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierFiltersDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierStateDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierStatusDTO;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierWritableDataDTO;
import org.openhab.core.cache.ExpiringCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PhilipsAirCoapAPIConnection
extends PhilipsAirAPIConnection {
    private final Logger logger = LoggerFactory.getLogger(PhilipsAirCoapAPIConnection.class);
    private static final String RESOURCE_PATH_STATUS = "/sys/dev/status";
    private static final String RESOURCE_PATH_SYNC = "/sys/dev/sync";
    private static final String RESOURCE_PATH_CONTROL = "/sys/dev/control";
    private static final int COAP_PORT = 5683;
    private static final long TIMEOUT = 25000L;
    private final Gson gson = new Gson();
    private ExpiringCache<String> coapStatus = new ExpiringCache(20000L, this::refreshData);
    private String host = "";
    private CoapClient client = new CoapClient();
    private long counter = 1L;
    private boolean hasSync = false;
    private long syncCounter = 0L;
    private int attempt = -1;
    private @Nullable CoapObserveRelation observe = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String refreshData() {
        try {
            String res;
            this.logger.debug("Refreshing data for {}", (Object)this.host);
            if (!this.coapStatus.isExpired() && (res = (String)this.coapStatus.getValue()) != null) {
                return res;
            }
            CoapObserveRelation reuseObserve = this.observe;
            if (reuseObserve != null && !reuseObserve.isCanceled()) {
                if (this.attempt < 2) {
                    this.logger.debug("Send COAP ping to {}:{}", (Object)this.client.getURI(), (Object)this.client.ping(25000L));
                    this.logger.debug("Reregister #{},{}", (Object)this.attempt, (Object)reuseObserve.reregister());
                    ++this.attempt;
                    return "";
                }
                this.logger.debug("Cancel request #{}", (Object)this.attempt);
                reuseObserve.proactiveCancel();
            }
            this.attempt = 0;
            final String uri = PhilipsAirCoapAPIConnection.getUriString(this.host, 5683, RESOURCE_PATH_STATUS);
            this.client.setURI(uri);
            if (!this.hasSync) {
                this.counter = this.getSync(this.counter);
                this.logger.debug("Counter for {}: {}", (Object)this.host, (Object)this.counter);
            }
            this.client.setURI(uri);
            Request request = Request.newGet();
            request.setURI(uri);
            request.setType(CoAP.Type.CON);
            request.setObserve();
            this.logger.debug("Send COAP ping to {}:{}", (Object)this.client.getURI(), (Object)this.client.ping(25000L));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logger.debug("Start Observe request {}", (Object)uri);
            this.observe = this.client.observeAndWait(request, new CoapHandler(){

                public void onLoad(@Nullable CoapResponse response) {
                    PhilipsAirCoapAPIConnection.this.processCoapResponse(uri, response);
                }

                public void onError() {
                    PhilipsAirCoapAPIConnection.this.logger.debug("Error for {}", (Object)uri);
                }
            });
            this.logger.debug("Finished refreshdata for {}", (Object)this.host);
            return "";
        }
        catch (IOException | ConnectorException e) {
            this.logger.debug("Error while refreshing {}: {}", (Object)this.host, (Object)e.getMessage());
        }
        return "";
    }

    private String processCoapResponse(String uri, @Nullable CoapResponse response) {
        if (response != null) {
            if (!response.isSuccess()) {
                this.logger.debug("Response is success: {}", (Object)response.isSuccess());
            }
            this.logger.trace("Response is advanced: {}", (Object)response.advanced());
            String content = response.getResponseText();
            if (content != null) {
                String resp = this.processResponse(content.trim(), uri);
                this.logger.info("Response {}", (Object)resp);
                if (resp.length() > 2) {
                    this.coapStatus.putValue((Object)resp);
                    return resp;
                }
            } else {
                this.logger.debug("Response content null for {}", (Object)response.advanced());
            }
        } else {
            this.logger.debug("Response is null for {}", (Object)uri);
        }
        return "";
    }

    private String processResponse(String rawResponse, String uri) {
        if (!rawResponse.isBlank()) {
            this.hasSync = true;
            this.logger.trace("Raw Response from {}: {}", (Object)uri, (Object)rawResponse);
            this.counter = this.getCounter(rawResponse);
            String decrypted = PhilipsAirCoapCipher.decryptMsg(rawResponse, this.logger);
            this.logger.debug("Response from {}: {}", (Object)uri, (Object)decrypted);
            JsonElement airResponse = JsonParser.parseString((String)decrypted);
            if (airResponse.isJsonObject() && airResponse.getAsJsonObject().has("state")) {
                JsonElement stateObj = airResponse.getAsJsonObject().get("state");
                if (stateObj.isJsonObject() && stateObj.getAsJsonObject().getAsJsonObject().has("reported")) {
                    return stateObj.getAsJsonObject().get("reported").toString();
                }
                this.logger.debug("Response does not contain 'reported' element");
            } else {
                this.logger.debug("Response does not contain 'state' element");
            }
        }
        ++this.syncCounter;
        if (this.syncCounter > 3L) {
            this.hasSync = false;
            this.syncCounter = 0L;
        }
        this.logger.debug("No response for {}", (Object)uri);
        return "";
    }

    private String refreshDataOld() {
        block8: {
            try {
                String rawResponse;
                this.logger.debug("Refreshing data for {}", (Object)this.host);
                String uri = PhilipsAirCoapAPIConnection.getUriString(this.host, 5683, RESOURCE_PATH_STATUS);
                if (!this.hasSync) {
                    this.counter = this.getSync(this.counter);
                    this.logger.debug("Counter {}", (Object)this.counter);
                }
                if (!this.hasSync) {
                    this.logger.debug("Send COAP ping to {}:{}", (Object)this.client.getURI(), (Object)this.client.ping(25000L));
                }
                if (!(rawResponse = this.get(this.client, uri, CoAP.Type.CON, !this.hasSync)).isBlank()) {
                    this.hasSync = true;
                    this.logger.debug("Rawesponse from {}: {}", (Object)uri, (Object)rawResponse);
                    this.counter = this.getCounter(rawResponse);
                    String decrypted = PhilipsAirCoapCipher.decryptMsg(rawResponse, this.logger);
                    this.logger.debug("Response from {}: {}", (Object)uri, (Object)decrypted);
                    JsonElement airResponse = JsonParser.parseString((String)decrypted);
                    if (airResponse.isJsonObject() && airResponse.getAsJsonObject().has("state")) {
                        JsonElement stateObj = airResponse.getAsJsonObject().get("state");
                        if (stateObj.isJsonObject() && stateObj.getAsJsonObject().getAsJsonObject().has("reported")) {
                            return stateObj.getAsJsonObject().get("reported").toString();
                        }
                        this.logger.debug("Response does not contain 'reported' element");
                    } else {
                        this.logger.debug("Response does not contain 'state' element");
                    }
                    break block8;
                }
                this.hasSync = false;
                this.logger.debug("No response for {}", (Object)uri);
                return "";
            }
            catch (IOException | ConnectorException e) {
                this.logger.debug("Error while refreshing {}: {}", (Object)this.host, (Object)e.getMessage());
            }
        }
        return "";
    }

    private long getCounter(String rawResponse) {
        if (rawResponse.length() >= 8) {
            String counterStr = rawResponse.substring(0, 8);
            try {
                this.counter = Long.parseUnsignedLong(counterStr, 16);
                this.logger.trace("Current counter: {}->{}", (Object)counterStr, (Object)this.counter);
            }
            catch (NumberFormatException e) {
                this.logger.debug("Error decoding '{}' to a number", (Object)counterStr);
            }
        } else {
            this.logger.debug("Error getting counter from response: '{}'", (Object)rawResponse);
        }
        return this.counter;
    }

    public PhilipsAirCoapAPIConnection(PhilipsAirConfiguration config) {
        super(config);
        if (!config.getHost().isEmpty()) {
            this.host = config.getHost();
        } else {
            this.logger.info("Host is empty, cannot start COAP connection");
        }
        if (config.getRefreshInterval() < 10) {
            this.logger.info("Refresh interval<10 not supported");
        }
        NetworkConfig netConfig = NetworkConfig.createStandardWithoutFile();
        NetworkConfig.getStandard().setString("DEDUPLICATOR", "NO_DEDUPLICATOR");
        netConfig.setString("DEDUPLICATOR", "NO_DEDUPLICATOR");
        CoapEndpoint endpoint = new CoapEndpoint.Builder().setNetworkConfig(netConfig).build();
        this.client.setEndpoint((Endpoint)endpoint);
        this.client.setTimeout(Long.valueOf(25000L));
        this.logger.debug("PhilipsAirCoapAPIConnection initialized using host {}", (Object)this.host);
    }

    @Override
    public PhilipsAirConfiguration getConfig() {
        return this.config;
    }

    @Override
    public synchronized @Nullable PhilipsAirPurifierDataDTO getAirPurifierStatus(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return (PhilipsAirPurifierDataDTO)this.gson.fromJson((String)this.coapStatus.getValue(), PhilipsAirPurifierDataDTO.class);
    }

    @Override
    public synchronized @Nullable PhilipsAirPurifierDeviceDTO getAirPurifierDevice(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return (PhilipsAirPurifierDeviceDTO)this.gson.fromJson((String)this.coapStatus.getValue(), PhilipsAirPurifierDeviceDTO.class);
    }

    @Override
    public synchronized @Nullable PhilipsAirPurifierFiltersDTO getAirPurifierFiltersStatus(String host) throws JsonSyntaxException, PhilipsAirAPIException {
        return (PhilipsAirPurifierFiltersDTO)this.gson.fromJson((String)this.coapStatus.getValue(), PhilipsAirPurifierFiltersDTO.class);
    }

    @Override
    public @Nullable PhilipsAirPurifierDataDTO sendCommand(String parameter, PhilipsAirPurifierWritableDataDTO value) {
        try {
            String response;
            long controlCounter = this.getSync(this.counter);
            this.logger.debug("ControlCounter from sync={}", (Object)controlCounter);
            JsonObject cmd = (JsonObject)this.gson.toJsonTree((Object)value);
            cmd.addProperty("CommandType", "app");
            cmd.addProperty("DeviceId", "");
            cmd.addProperty("EnduserId", "1");
            PhilipsAirPurifierStateDTO state = new PhilipsAirPurifierStateDTO();
            state.setDesired(cmd);
            PhilipsAirPurifierStatusDTO fullCmd = new PhilipsAirPurifierStatusDTO();
            fullCmd.setState(state);
            String commandValue = this.gson.toJson((Object)fullCmd).toString();
            this.logger.info("Sending command {}", (Object)commandValue);
            String encryped = PhilipsAirCoapCipher.encryptedMsg(commandValue, ++controlCounter, this.logger);
            String string = response = encryped == null ? "Encrypted message failed" : this.post(this.client, this.host, 5683, RESOURCE_PATH_CONTROL, encryped);
            if (response.contentEquals("{\"status\":\"success\"}")) {
                Thread.sleep(1000L);
                this.coapStatus.refreshValue();
                return (PhilipsAirPurifierDataDTO)this.gson.fromJson((String)this.coapStatus.getValue(), PhilipsAirPurifierDataDTO.class);
            }
            this.logger.debug("Command failed. Response: {}", (Object)response);
        }
        catch (JsonSyntaxException | IOException | InterruptedException | ConnectorException e) {
            this.logger.info("Error sending command '{}': {}", new Object[]{this.gson.toJson((Object)value), e.getMessage(), e});
        }
        return null;
    }

    private long getSync(long counter) throws ConnectorException, IOException {
        String controlCounterResponse = this.post(this.client, this.host, 5683, RESOURCE_PATH_SYNC, String.format("%08X", counter));
        return this.getCounter(controlCounterResponse);
    }

    private static String getUriString(String server, int port, String resourcePath) {
        return "coap://" + server + ":" + port + resourcePath;
    }

    private String get(CoapClient client, String uri, CoAP.Type type, boolean sendPing) throws ConnectorException, IOException {
        this.logger.trace("Getting {}", (Object)uri);
        client.setURI(uri);
        if (sendPing) {
            this.logger.debug("Send COAP ping to {}:{}", (Object)client.getURI(), (Object)client.ping(25000L));
        }
        Request request = Request.newGet();
        request.setType(type);
        request.setObserve();
        CoapResponse response = client.advanced(request);
        if (response != null) {
            this.logger.trace("Response from {}: {}", (Object)response.advanced().getSourceContext().getPeerAddress(), (Object)Utils.prettyPrint((CoapResponse)response));
            return response.getResponseText();
        }
        this.logger.debug("No response received for {}.", (Object)uri);
        return "";
    }

    private String post(CoapClient client, String server, int port, String resourcePath, String body) throws ConnectorException, IOException {
        String uri = "coap://" + server + ":" + port + resourcePath;
        client.setURI(uri);
        Request request = Request.newPost();
        request.setPayload(body);
        CoapResponse response = client.advanced(request);
        if (response != null) {
            this.logger.trace("POST {} -> Response: {}", (Object)uri, (Object)Utils.prettyPrint((CoapResponse)response));
            this.logger.debug("POST {} -> Response: {}", (Object)uri, (Object)response.getResponseText());
            return response.getResponseText();
        }
        this.logger.debug("POST {}  -> No response received.", (Object)uri);
        return "";
    }
}

