/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal.connection;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.util.HexUtils;
import org.slf4j.Logger;

@NonNullByDefault
public class PhilipsAirCoapCipher {
    private static final String SHARED_SECRET = "JiangPan";

    public static String decryptMsg(@Nullable String responseText, Logger logger) {
        if (responseText == null || responseText.isBlank()) {
            return "";
        }
        String counter = responseText.substring(0, 8);
        String hash = responseText.substring(responseText.length() - 64, responseText.length());
        String encodedMessageAndCounter = responseText.substring(0, responseText.length() - 64);
        String encodedMessage = responseText.substring(8, responseText.length() - 64);
        try {
            String calculatedHash = PhilipsAirCoapCipher.toSHA(encodedMessageAndCounter);
            if (!hash.contentEquals(calculatedHash)) {
                logger.warn("Message Hash mismatch hash expected '{}' got '{}' ", (Object)hash, (Object)calculatedHash);
            }
            String keyAndIv = PhilipsAirCoapCipher.toMD5(SHARED_SECRET + counter);
            String secret = keyAndIv.substring(0, keyAndIv.length() / 2);
            String iv = keyAndIv.substring(keyAndIv.length() / 2);
            String decryptedMsg = PhilipsAirCoapCipher.decrypt(encodedMessage, secret, iv);
            if (logger.isTraceEnabled()) {
                logger.trace("Decrypting: '{}'", (Object)responseText);
                logger.trace("Secret: {}, iv {}", (Object)secret, (Object)iv);
                logger.trace("Seq: {}, encodedMessage: {}", (Object)counter, (Object)encodedMessage);
                logger.trace("Calculated Hash: {}, Message Hash {}", (Object)calculatedHash, (Object)hash);
                logger.trace("Decrypted: {}", (Object)decryptedMsg);
            }
            return decryptedMsg;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.debug("Error decrypting message: {}. Message Text: '{}'", (Object)e.getMessage(), (Object)responseText);
            return "Could not decrypt";
        }
    }

    public static @Nullable String encryptedMsg(String commandText, long counter, Logger logger) {
        return PhilipsAirCoapCipher.encryptedMsg(commandText, String.format("%08X", counter), logger);
    }

    public static @Nullable String encryptedMsg(String commandText, String sequence, Logger logger) {
        try {
            String keyAndIv = PhilipsAirCoapCipher.toMD5(SHARED_SECRET + sequence);
            String secret = keyAndIv.substring(0, keyAndIv.length() / 2);
            String iv = keyAndIv.substring(keyAndIv.length() / 2);
            String encryptedCmd = PhilipsAirCoapCipher.encrypt(commandText, secret, iv);
            String calculatedHash = PhilipsAirCoapCipher.toSHA(String.valueOf(sequence) + encryptedCmd);
            String encrypedMessage = String.valueOf(sequence) + encryptedCmd + calculatedHash;
            if (logger.isTraceEnabled()) {
                logger.trace("Encrypting: '{}'", (Object)commandText);
                logger.trace("Secret: {}, iv {}", (Object)secret, (Object)iv);
                logger.trace("Decrypted: {}", (Object)encryptedCmd);
                logger.trace("Hash: {}", (Object)calculatedHash);
                logger.trace("Encypted message: {}", (Object)encrypedMessage);
            }
            return encrypedMessage;
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.trace("Error decoding message: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static String toSHA(String originalString) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] encodedhash = digest.digest(originalString.getBytes(StandardCharsets.UTF_8));
        return HexUtils.bytesToHex((byte[])encodedhash);
    }

    private static String toMD5(String originalString) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] encodedhash = digest.digest(originalString.getBytes(StandardCharsets.UTF_8));
        return HexUtils.bytesToHex((byte[])encodedhash);
    }

    public static String decrypt(String strToDecrypt, String secret, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)secretKey, ivspec);
        return new String(cipher.doFinal(HexUtils.hexToBytes((String)strToDecrypt)));
    }

    public static String encrypt(String strToEncrypt, String secret, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        IvParameterSpec ivspec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)secretKey, ivspec);
        return HexUtils.bytesToHex((byte[])cipher.doFinal(strToEncrypt.getBytes("UTF-8")));
    }
}

