/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal.discovery;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.exception.ConnectorException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.binding.philipsair.internal.PhilipsAirBindingConstants;
import org.openhab.binding.philipsair.internal.model.PhilipsAirPurifierDeviceDTO;
import org.openhab.core.config.discovery.AbstractDiscoveryService;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultBuilder;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.net.NetUtil;
import org.openhab.core.net.NetworkAddressService;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={DiscoveryService.class}, configurationPid={"discovery.philipsair"})
public class PhilipsAirCoapDiscovery
extends AbstractDiscoveryService {
    private static final int DISCOVERY_TIME = 15;
    private static final String PATH = "sys/dev/info";
    private static final int COAP_PORT = 5683;
    private static final long BACKGROUND_DISCOVERY_INTERVAL = 1800L;
    private final Gson gson = new Gson();
    private final Logger logger = LoggerFactory.getLogger(PhilipsAirCoapDiscovery.class);
    private CoapClient client = new CoapClient();
    private @Nullable ScheduledFuture<?> coapDiscoveryJob;
    private NetworkAddressService networkAddressService;

    @Activate
    public PhilipsAirCoapDiscovery(@Reference ConfigurationAdmin configAdmin, @Reference NetworkAddressService networkAddressService) throws IllegalArgumentException {
        super(15);
        NetworkConfig netConfig = NetworkConfig.createStandardWithoutFile();
        CoapEndpoint endpoint = new CoapEndpoint.Builder().setNetworkConfig(netConfig).build();
        this.networkAddressService = networkAddressService;
        this.client = new CoapClient();
        this.client.setEndpoint((Endpoint)endpoint);
    }

    protected void startBackgroundDiscovery() {
        this.stopBackgroundDiscovery();
        ScheduledFuture<?> coapDiscoveryJob = this.coapDiscoveryJob;
        if (coapDiscoveryJob == null || coapDiscoveryJob.isCancelled()) {
            this.logger.debug("Starting PhilipsAir (COAP) background discovery job");
            coapDiscoveryJob = this.scheduler.scheduleWithFixedDelay(this::backgroundScan, 0L, 1800L, TimeUnit.SECONDS);
        }
    }

    private void backgroundScan() {
        this.logger.debug("Initiated PhilipsAir (COAP) background discovery scan");
        this.startScan();
    }

    protected void stopBackgroundDiscovery() {
        ScheduledFuture<?> coapDiscoveryJob = this.coapDiscoveryJob;
        if (coapDiscoveryJob != null) {
            coapDiscoveryJob.cancel(true);
            this.coapDiscoveryJob = null;
        }
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return PhilipsAirBindingConstants.SUPPORTED_COAP_THING_TYPES_UIDS;
    }

    protected void startScan() {
        this.logger.debug("Start COAP discovery");
        HashSet<String> broadcastAddresses = new HashSet<String>(NetUtil.getAllBroadcastAddresses());
        String configuredBroadcastAddress = this.networkAddressService.getConfiguredBroadcastAddress();
        if (configuredBroadcastAddress != null) {
            broadcastAddresses.add(configuredBroadcastAddress);
        }
        broadcastAddresses.add("224.0.1.187");
        this.logger.debug("Broadcast to {} addresses", (Object)broadcastAddresses.size());
        for (String host : broadcastAddresses) {
            try {
                this.mget(this.client, 5683, PATH, host);
            }
            catch (IOException | ConnectorException e) {
                this.logger.debug("Error while discovering: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void discovered(String response, String host) {
        try {
            PhilipsAirPurifierDeviceDTO info = (PhilipsAirPurifierDeviceDTO)this.gson.fromJson(response, PhilipsAirPurifierDeviceDTO.class);
            if (info == null) {
                this.logger.debug("Philips Air Purifier (COAP protocol) discovery result could not parse response from IP={}, '{}'", (Object)host, (Object)response);
                return;
            }
            if (info.getDeviceId() == null) {
                this.logger.debug("Philips Air Purifier (COAP protocol) discovery result could not find deviceId  IP={}, '{}'", (Object)host, (Object)response);
                return;
            }
            this.logger.debug("Creating Philips Air Purifier (COAP protocol) discovery result for: IP={}, {}", (Object)host, (Object)response);
            ThingUID thingUid = new ThingUID(PhilipsAirBindingConstants.THING_TYPE_COAP, info.getDeviceId());
            HashMap<String, Object> properties = new HashMap<String, Object>();
            PhilipsAirCoapDiscovery.addProperty(properties, "host", host);
            PhilipsAirCoapDiscovery.addProperty(properties, "deviceUUID", info.getDeviceId());
            PhilipsAirCoapDiscovery.addProperty(properties, "manufacturer", "Philips");
            PhilipsAirCoapDiscovery.addProperty(properties, "vendor", "Philips");
            PhilipsAirCoapDiscovery.addProperty(properties, "modelId", info.getModelId());
            PhilipsAirCoapDiscovery.addProperty(properties, "deviceType", info.getType());
            String label = String.format("Philips AirPurifier %s %s", info.getName(), info.getModelId());
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)thingUid).withProperties(properties).withLabel(label).withRepresentationProperty("deviceUUID").build();
            this.logger.debug("DiscoveryResult with uid {} label : {} ", (Object)result.getThingUID().getAsString(), (Object)result.getLabel());
            this.thingDiscovered(result);
        }
        catch (JsonSyntaxException e) {
            this.logger.debug("Error while processing discovery result from IP={}, {}", (Object)host, (Object)response);
        }
    }

    private static void addProperty(Map<String, Object> properties, String key, @Nullable String value) {
        properties.put(key, value != null ? value : "");
    }

    private void mget(CoapClient client, int port, String resourcePath, String host) throws ConnectorException, IOException {
        String uri = "coap://" + host + ":" + port + "/" + resourcePath;
        this.logger.debug("Send discovery request: {}", (Object)uri);
        client.setURI(uri);
        Request multicastRequest = Request.newGet();
        multicastRequest.setType(CoAP.Type.NON);
        MultiCoapHandler handler = new MultiCoapHandler(this, this.logger);
        client.advanced((CoapHandler)handler, multicastRequest);
        while (handler.waitOn(15000L)) {
        }
    }

    private static class MultiCoapHandler
    implements CoapHandler {
        private boolean on;
        private final PhilipsAirCoapDiscovery philipsAirCoapDiscovery;
        private final Logger logger;

        public MultiCoapHandler(PhilipsAirCoapDiscovery philipsAirCoapDiscovery, Logger logger) {
            this.philipsAirCoapDiscovery = philipsAirCoapDiscovery;
            this.logger = logger;
        }

        public synchronized boolean waitOn(long timeout) {
            this.on = false;
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.on;
        }

        private synchronized void on() {
            this.on = true;
            this.notifyAll();
        }

        public void onLoad(@Nullable CoapResponse response) {
            this.on();
            if (response != null) {
                InetSocketAddress ip = response.advanced().getSourceContext().getPeerAddress();
                this.logger.trace("Received coap response from '{}' - {}", (Object)ip, (Object)Utils.prettyPrint((CoapResponse)response));
                String resTxt = response.getResponseText();
                if (resTxt != null && !resTxt.isBlank()) {
                    this.philipsAirCoapDiscovery.discovered(response.getResponseText(), ip.getHostString());
                }
            } else {
                this.logger.debug("Received NULL coap response ");
            }
        }

        public void onError() {
            this.logger.info("Unspecified COAP error while running discovery");
        }
    }
}

