/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.philipsair.internal.discovery;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.openhab.binding.philipsair.internal.PhilipsAirBindingConstants;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultBuilder;
import org.openhab.core.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={UpnpDiscoveryParticipant.class}, immediate=true)
public class PhilipsAirUpnpDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    private final Logger logger = LoggerFactory.getLogger(PhilipsAirUpnpDiscoveryParticipant.class);
    private boolean isAutoDiscoveryEnabled = true;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.activateOrModifyService(componentContext);
    }

    @Modified
    protected void modified(ComponentContext componentContext) {
        this.activateOrModifyService(componentContext);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void activateOrModifyService(ComponentContext componentContext) {
        @Nullable Dictionary properties = componentContext.getProperties();
        String autoDiscoveryPropertyValue = (String)properties.get("enableAutoDiscovery");
        if (autoDiscoveryPropertyValue != null && autoDiscoveryPropertyValue.length() != 0) {
            this.isAutoDiscoveryEnabled = Boolean.valueOf(autoDiscoveryPropertyValue);
        }
    }

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return PhilipsAirBindingConstants.SUPPORTED_UPNP_THING_TYPES_UIDS;
    }

    public @Nullable DiscoveryResult createResult(RemoteDevice device) {
        if (!this.isAutoDiscoveryEnabled) {
            return null;
        }
        ThingUID uid = this.getThingUID(device);
        if (uid != null) {
            this.logger.trace("Creating with uid {}", (Object)uid.getAsString());
            HashMap<String, Object> properties = new HashMap<String, Object>();
            RemoteDeviceIdentity identity = (RemoteDeviceIdentity)device.getIdentity();
            if (identity != null) {
                PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "host", identity.getDescriptorURL().getHost());
                String idString = identity.getUdn().getIdentifierString();
                if (idString != null) {
                    PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "deviceUUID", idString);
                    int macIndex = idString.lastIndexOf(45);
                    if (macIndex > 0) {
                        PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "macAddress", idString.substring(idString.lastIndexOf(45) + 1));
                    }
                }
            }
            DeviceDetails details = device.getDetails();
            String label = "Philips AirPurifier";
            if (details != null) {
                PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "manufacturer", details.getManufacturerDetails().getManufacturer());
                ModelDetails modelDetails = device.getDetails().getModelDetails();
                if (modelDetails != null) {
                    PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "vendor", "Philips");
                    PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "modelId", modelDetails.getModelNumber());
                    PhilipsAirUpnpDiscoveryParticipant.addProperty(properties, "deviceType", modelDetails.getModelName());
                    label = String.format("Philips %s %s", modelDetails.getModelName(), modelDetails.getModelNumber());
                }
            }
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(label).withRepresentationProperty("deviceUUID").build();
            this.logger.debug("DiscoveryResult with uid {} label : {} ", (Object)result.getThingUID().getAsString(), (Object)result.getLabel());
            return result;
        }
        return null;
    }

    public @Nullable ThingUID getThingUID(RemoteDevice device) {
        String modelName;
        DeviceDetails details = device.getDetails();
        ModelDetails modelDetails = details != null ? details.getModelDetails() : null;
        String string = modelName = modelDetails != null ? modelDetails.getModelName().toLowerCase() : null;
        if (details == null || modelDetails == null || !"AirPurifier".equalsIgnoreCase(modelName)) {
            this.logger.trace("Device not recognized {}", (Object)device.toString());
            return null;
        }
        String modelNumber = modelDetails.getModelNumber().toLowerCase();
        ThingTypeUID thingType = PhilipsAirBindingConstants.THING_TYPE_UNIVERSAL;
        thingType = "ac2889_10".startsWith(modelNumber) ? PhilipsAirBindingConstants.THING_TYPE_AC2889_10 : ("ac1214_10".startsWith(modelNumber) ? PhilipsAirBindingConstants.THING_TYPE_AC1214_10 : ("ac2729".startsWith(modelNumber) ? PhilipsAirBindingConstants.THING_TYPE_AC2729 : ("ac3829_10".startsWith(modelNumber) ? PhilipsAirBindingConstants.THING_TYPE_AC3829_10 : PhilipsAirBindingConstants.THING_TYPE_UNIVERSAL)));
        this.logger.debug("Attempt to create Philips Air things {} {}", (Object)modelName, (Object)modelDetails.getModelNumber());
        return new ThingUID(thingType, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
    }

    private static void addProperty(Map<String, Object> properties, String key, @Nullable String value) {
        properties.put(key, value != null ? value : "");
    }
}

